/* A Bison parser, made from ../src/builtin-func.y, by GNU bison 1.75.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON	1

/* Pure parsers.  */
#define YYPURE	0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_LPP = 258,
     TOK_RPP = 259,
     TOK_LPB = 260,
     TOK_RPB = 261,
     TOK_LPPB = 262,
     TOK_RPPB = 263,
     TOK_VAR_ARG = 264,
     TOK_BOOL = 265,
     TOK_FUNCTION = 266,
     TOK_REWRITER = 267,
     TOK_EVENT = 268,
     TOK_CONST = 269,
     TOK_WRITE = 270,
     TOK_PUSH = 271,
     TOK_EOF = 272,
     TOK_TRACE = 273,
     TOK_ARGS = 274,
     TOK_ARG = 275,
     TOK_ARGC = 276,
     TOK_ID = 277,
     TOK_ATTR = 278,
     TOK_CSTR = 279,
     TOK_LF = 280,
     TOK_WS = 281,
     TOK_COMMENT = 282,
     TOK_ATOM = 283,
     TOK_C_TOKEN = 284
   };
#endif
#define TOK_LPP 258
#define TOK_RPP 259
#define TOK_LPB 260
#define TOK_RPB 261
#define TOK_LPPB 262
#define TOK_RPPB 263
#define TOK_VAR_ARG 264
#define TOK_BOOL 265
#define TOK_FUNCTION 266
#define TOK_REWRITER 267
#define TOK_EVENT 268
#define TOK_CONST 269
#define TOK_WRITE 270
#define TOK_PUSH 271
#define TOK_EOF 272
#define TOK_TRACE 273
#define TOK_ARGS 274
#define TOK_ARG 275
#define TOK_ARGC 276
#define TOK_ID 277
#define TOK_ATTR 278
#define TOK_CSTR 279
#define TOK_LF 280
#define TOK_WS 281
#define TOK_COMMENT 282
#define TOK_ATOM 283
#define TOK_C_TOKEN 284




/* Copy the first part of user declarations.  */
#line 1 "../src/builtin-func.y"

#include <vector>
#include <stdio.h>
#include <stdlib.h>

extern int line_number;
extern char* input_filename;

#define print_line_directive(fp) fprintf(fp, "\n#line %d \"%s\"\n", line_number, input_filename)

extern FILE* fp_bro_init;
extern FILE* fp_func_def;
extern FILE* fp_func_h;
extern FILE* fp_func_init;
extern FILE* fp_netvar_h;
extern FILE* fp_netvar_def;
extern FILE* fp_netvar_init;

int in_c_code = 0;
int definition_type;
const char* bro_prefix;
const char* c_prefix;

enum {
	C_SEGMENT_DEF,
	FUNC_DEF,
	REWRITER_DEF,
	EVENT_DEF,
};

void set_definition_type(int type)
	{
	definition_type = type;
	switch ( type ) {
	case FUNC_DEF:
		bro_prefix = "";
		c_prefix = "bro_";
		break;

	case REWRITER_DEF:
		bro_prefix = "rewrite_";
		c_prefix = "bro_rewrite_";
		break;

	case EVENT_DEF:
		bro_prefix = "";
		break;

	case C_SEGMENT_DEF:
		break;
	}
	}

const char* arg_list_name = "BiF_ARGS";
const char* trace_rewriter_name = "trace_rewriter";

#include "bif_arg.h"

int var_arg; // whether the number of arguments is variable
std::vector<BuiltinFuncArg*> args;

extern const char* decl_name;
extern int yyerror(const char[]);
extern int yylex();

char* concat(char* str1, char* str2)
	{
	int len1 = strlen(str1);
	int len2 = strlen(str2);

	char* s = new char[len1 + len2 +1];

	memcpy(s, str1, len1);
	memcpy(s + len1, str2, len2);

	s[len1+len2] = '\0';

	return s;
	}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#ifndef YYSTYPE
#line 95 "../src/builtin-func.y"
typedef union {
	char* str;
	int val;
} yystype;
/* Line 193 of /usr/local/share/bison/yacc.c.  */
#line 217 "y.tab.c"
# define YYSTYPE yystype
# define YYSTYPE_IS_TRIVIAL 1
#endif

#ifndef YYLTYPE
typedef struct yyltype
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} yyltype;
# define YYLTYPE yyltype
# define YYLTYPE_IS_TRIVIAL 1
#endif

/* Copy the second part of user declarations.  */


/* Line 213 of /usr/local/share/bison/yacc.c.  */
#line 238 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];	\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
#define YYLAST   114

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  34
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  32
/* YYNRULES -- Number of rules. */
#define YYNRULES  55
/* YYNRULES -- Number of states. */
#define YYNSTATES  101

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   284

#define YYTRANSLATE(X) \
  ((unsigned)(X) <= YYMAXUTOK ? yytranslate[X] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    30,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    31,    32,
       2,    33,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     7,     9,    11,    13,    15,    17,    19,
      25,    31,    37,    42,    47,    52,    53,    57,    59,    61,
      63,    64,    67,    72,    76,    78,    80,    82,    84,    90,
      94,   100,   102,   107,   111,   112,   113,   116,   119,   125,
     127,   131,   133,   135,   137,   139,   141,   143,   145,   147,
     149,   151,   153,   156,   159,   162
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      35,     0,    -1,    35,    36,    65,    -1,    65,    -1,    37,
      -1,    38,    -1,    39,    -1,    62,    -1,    40,    -1,    46,
      65,    49,    47,    32,    -1,    44,    65,    48,    47,    57,
      -1,    45,    65,    49,    47,    57,    -1,    41,    42,    43,
      32,    -1,    14,    65,    22,    65,    -1,    33,    65,    10,
      65,    -1,    -1,    43,    23,    65,    -1,    11,    -1,    12,
      -1,    13,    -1,    -1,    49,    56,    -1,    50,    53,    52,
      65,    -1,    22,    65,    51,    -1,     3,    -1,     4,    -1,
      54,    -1,    65,    -1,    54,    30,    65,    55,    65,    -1,
      65,    55,    65,    -1,    22,    65,    31,    65,    22,    -1,
       9,    -1,    31,    65,    22,    65,    -1,    60,    63,    61,
      -1,    -1,    -1,     5,    58,    -1,     6,    59,    -1,     7,
      58,    63,    59,     8,    -1,    65,    -1,    63,    64,    65,
      -1,    22,    -1,    29,    -1,    20,    -1,    19,    -1,    21,
      -1,    18,    -1,    15,    -1,    16,    -1,    17,    -1,    24,
      -1,    28,    -1,    65,    26,    -1,    65,    25,    -1,    65,
      27,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   102,   102,   104,   124,   125,   126,   127,   128,   131,
     134,   137,   140,   150,   159,   165,   166,   172,   176,   180,
     184,   190,   195,   218,   270,   274,   277,   278,   282,   283,
     287,   289,   297,   306,   313,   320,   324,   375,   383,   386,
     388,   392,   394,   396,   398,   400,   402,   404,   406,   408,
     410,   412,   416,   418,   420,   427
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "TOK_LPP", "TOK_RPP", "TOK_LPB", "TOK_RPB", 
  "TOK_LPPB", "TOK_RPPB", "TOK_VAR_ARG", "TOK_BOOL", "TOK_FUNCTION", 
  "TOK_REWRITER", "TOK_EVENT", "TOK_CONST", "TOK_WRITE", "TOK_PUSH", 
  "TOK_EOF", "TOK_TRACE", "TOK_ARGS", "TOK_ARG", "TOK_ARGC", "TOK_ID", 
  "TOK_ATTR", "TOK_CSTR", "TOK_LF", "TOK_WS", "TOK_COMMENT", "TOK_ATOM", 
  "TOK_C_TOKEN", "','", "':'", "';'", "'='", "$accept", "definitions", 
  "definition", "event_def", "func_def", "rewriter_def", "const_def", 
  "const_def_1", "const_init", "opt_attr", "func_prefix", 
  "rewriter_prefix", "event_prefix", "end_of_head", "typed_head", 
  "plain_head", "head_1", "arg_begin", "arg_end", "args", "args_1", "arg", 
  "return_type", "body", "c_code_begin", "c_code_end", "body_start", 
  "body_end", "c_code_segment", "c_body", "c_atom", "opt_ws", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      44,    58,    59,    61
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    34,    35,    35,    36,    36,    36,    36,    36,    37,
      38,    39,    40,    41,    42,    43,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    53,    54,    54,
      55,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      63,    64,    64,    64,    64,    64,    64,    64,    64,    64,
      64,    64,    65,    65,    65,    65
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     3,     1,     1,     1,     1,     1,     1,     5,
       5,     5,     4,     4,     4,     0,     3,     1,     1,     1,
       0,     2,     4,     3,     1,     1,     1,     1,     5,     3,
       5,     1,     4,     3,     0,     0,     2,     2,     5,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
      55,     0,     3,     1,    34,    17,    18,    19,    55,    55,
       4,     5,     6,     8,     0,    55,    55,    55,     7,    53,
      52,    54,    55,     0,     2,    55,    15,     0,     0,     0,
      35,    39,    55,     0,     0,    55,    20,     0,    55,    20,
      20,    47,    48,    49,    46,    44,    43,    45,    41,    50,
      51,    42,     0,    55,    13,    55,    55,    12,     0,     0,
      55,    21,     0,    26,    27,     0,     0,    38,    40,    14,
      16,    24,    23,    34,    10,    55,     0,    25,    55,    55,
      31,    55,    55,    11,     9,    36,     0,    55,    22,     0,
       0,    29,    35,    33,    32,    55,    55,    37,    28,     0,
      30
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     1,     9,    10,    11,    12,    13,    14,    26,    34,
      15,    16,    17,    59,    36,    37,    38,    72,    78,    62,
      63,    82,    61,    74,    22,    52,    75,    93,    18,    30,
      53,    31
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -46
static const yysigned_char yypact[] =
{
     -46,    77,   -14,   -46,   -46,   -46,   -46,   -46,   -46,   -46,
     -46,   -46,   -46,   -46,   -27,   -46,   -46,   -46,   -46,   -46,
     -46,   -46,   -46,    15,   -14,   -46,   -46,    75,    75,    75,
      46,   -14,   -46,     4,   -22,   -46,   -46,   -24,   -46,   -46,
     -46,   -46,   -46,   -46,   -46,   -46,   -46,   -46,   -46,   -46,
     -46,   -46,    16,   -46,   -14,   -46,   -46,   -46,     1,    28,
     -46,   -46,    35,    13,    -4,    28,     2,   -46,   -14,   -14,
     -14,   -46,   -46,   -46,   -46,   -46,    81,   -46,   -46,   -46,
     -46,   -46,   -46,   -46,   -46,   -46,    30,   -46,   -14,    -4,
      67,   -14,   -46,   -46,   -14,   -46,   -46,   -46,   -14,    87,
     -46
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -46,   -46,   -46,   -46,   -46,   -46,   -46,   -46,   -46,   -46,
     -46,   -46,   -46,   -37,   -46,    -9,   -46,   -46,   -46,   -46,
     -46,   -45,   -46,    -8,    -2,   -23,   -46,   -46,   -46,    -3,
     -46,     0
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, parse error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
       2,    56,    65,    66,    71,    80,    25,    60,    23,    24,
      57,    19,    20,    21,    55,    27,    28,    29,    81,    39,
      40,    19,    20,    21,    67,    33,    19,    20,    21,    19,
      20,    21,    54,    73,    84,    58,    92,    32,    64,    77,
      19,    20,    21,    79,    95,    41,    42,    43,    44,    45,
      46,    47,    48,    68,    49,    69,    70,    83,    50,    51,
      76,    41,    42,    43,    44,    45,    46,    47,    48,    97,
      49,    85,    86,     0,    50,    51,     0,     3,    88,    89,
       0,    90,    91,     0,     4,     0,     0,    94,     5,     6,
       7,     8,    19,    20,    21,    98,    99,    35,    96,     0,
      19,    20,    21,    87,     0,     0,    19,    20,    21,   100,
       0,     0,    19,    20,    21
};

static const yysigned_char yycheck[] =
{
       0,    23,    39,    40,     3,     9,    33,    31,     8,     9,
      32,    25,    26,    27,    10,    15,    16,    17,    22,    28,
      29,    25,    26,    27,     8,    25,    25,    26,    27,    25,
      26,    27,    32,     5,    32,    35,     6,    22,    38,     4,
      25,    26,    27,    30,    89,    15,    16,    17,    18,    19,
      20,    21,    22,    53,    24,    55,    56,    65,    28,    29,
      60,    15,    16,    17,    18,    19,    20,    21,    22,    92,
      24,    73,    75,    -1,    28,    29,    -1,     0,    78,    79,
      -1,    81,    82,    -1,     7,    -1,    -1,    87,    11,    12,
      13,    14,    25,    26,    27,    95,    96,    22,    31,    -1,
      25,    26,    27,    22,    -1,    -1,    25,    26,    27,    22,
      -1,    -1,    25,    26,    27
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    35,    65,     0,     7,    11,    12,    13,    14,    36,
      37,    38,    39,    40,    41,    44,    45,    46,    62,    25,
      26,    27,    58,    65,    65,    33,    42,    65,    65,    65,
      63,    65,    22,    65,    43,    22,    48,    49,    50,    49,
      49,    15,    16,    17,    18,    19,    20,    21,    22,    24,
      28,    29,    59,    64,    65,    10,    23,    32,    65,    47,
      31,    56,    53,    54,    65,    47,    47,     8,    65,    65,
      65,     3,    51,     5,    57,    60,    65,     4,    52,    30,
       9,    22,    55,    57,    32,    58,    63,    22,    65,    65,
      65,    65,     6,    61,    65,    55,    31,    59,    65,    65,
      22
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)           \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#define YYLEX	yylex ()

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*-----------------------------.
| Print this symbol on YYOUT.  |
`-----------------------------*/

static void
#if defined (__STDC__) || defined (__cplusplus)
yysymprint (FILE* yyout, int yytype, YYSTYPE yyvalue)
#else
yysymprint (yyout, yytype, yyvalue)
    FILE* yyout;
    int yytype;
    YYSTYPE yyvalue;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvalue;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyout, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyout, yytoknum[yytype], yyvalue);
# endif
    }
  else
    YYFPRINTF (yyout, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyout, ")");
}
#endif /* YYDEBUG. */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
#if defined (__STDC__) || defined (__cplusplus)
yydestruct (int yytype, YYSTYPE yyvalue)
#else
yydestruct (yytype, yyvalue)
    int yytype;
    YYSTYPE yyvalue;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvalue;

  switch (yytype)
    {
      default:
        break;
    }
}



/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of parse errors so far.  */
int yynerrs;


int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with.  */

  if (yychar <= 0)		/* This means end of input.  */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more.  */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

      /* We have to keep this `#if YYDEBUG', since we use variables
	 which are defined only if `YYDEBUG' is set.  */
      YYDPRINTF ((stderr, "Next token is "));
      YYDSYMPRINT ((stderr, yychar1, yylval));
      YYDPRINTF ((stderr, "\n"));
    }

  /* If the proper action on seeing token YYCHAR1 is to reduce or to
     detect an error, take that action.  */
  yyn += yychar1;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yychar1)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];



#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn - 1, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] >= 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif
  switch (yyn)
    {
        case 2:
#line 103 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", yyvsp[0].str); }
    break;

  case 3:
#line 105 "../src/builtin-func.y"
    {
			char auto_gen_comment[1024 + strlen(input_filename)];

			sprintf(auto_gen_comment,
				"This file was automatically generated by bifcl from %s.",
				input_filename);

			fprintf(fp_bro_init, "# %s\n\n", auto_gen_comment);
			fprintf(fp_func_def, "// %s\n\n", auto_gen_comment);
			fprintf(fp_func_h, "// %s\n\n", auto_gen_comment);
			fprintf(fp_func_init, "// %s\n\n", auto_gen_comment);
			fprintf(fp_netvar_def, "// %s\n\n", auto_gen_comment);
			fprintf(fp_netvar_h, "// %s\n\n", auto_gen_comment);
			fprintf(fp_netvar_init, "// %s\n\n", auto_gen_comment);

			fprintf(fp_func_def, "%s", yyvsp[0].str);
			}
    break;

  case 12:
#line 141 "../src/builtin-func.y"
    {
			fprintf(fp_bro_init, ";\n");
			fprintf(fp_netvar_h, "extern int %s;\n", decl_name);
			fprintf(fp_netvar_def, "int %s;\n", decl_name);
			fprintf(fp_netvar_init, "\t%s = internal_val(\"%s\")->AsBool();\n",
				decl_name, decl_name);
			}
    break;

  case 13:
#line 151 "../src/builtin-func.y"
    {
			decl_name = yyvsp[-1].str;
			fprintf(fp_bro_init, "const%s", yyvsp[-2].str);
			fprintf(fp_bro_init, "%s: bool%s", yyvsp[-1].str, yyvsp[0].str);
			}
    break;

  case 14:
#line 160 "../src/builtin-func.y"
    {
			fprintf(fp_bro_init, "=%s%c%s", yyvsp[-2].str, (yyvsp[-1].val) ? 'T' : 'F', yyvsp[0].str);
			}
    break;

  case 16:
#line 167 "../src/builtin-func.y"
    {
			fprintf(fp_bro_init, "%s%s", yyvsp[-1].str, yyvsp[0].str);
			}
    break;

  case 17:
#line 173 "../src/builtin-func.y"
    { set_definition_type(FUNC_DEF); }
    break;

  case 18:
#line 177 "../src/builtin-func.y"
    { set_definition_type(REWRITER_DEF); }
    break;

  case 19:
#line 181 "../src/builtin-func.y"
    { set_definition_type(EVENT_DEF); }
    break;

  case 20:
#line 185 "../src/builtin-func.y"
    {
			fprintf(fp_bro_init, ";\n");
			}
    break;

  case 21:
#line 191 "../src/builtin-func.y"
    {
			}
    break;

  case 22:
#line 196 "../src/builtin-func.y"
    {
			if ( var_arg )
				fprintf(fp_bro_init, "va_args: any");
			else
				{
				if ( definition_type == REWRITER_DEF )
					fprintf(fp_bro_init, "c: connection");

				for ( int i = 0; i < args.size(); ++i )
					{
					if ( i > 0 || definition_type == REWRITER_DEF )
						fprintf(fp_bro_init, ", ");
					args[i]->PrintBro(fp_bro_init);
					}
				}

			fprintf(fp_bro_init, ")");

			fprintf(fp_func_def, "%s", yyvsp[0].str);
			}
    break;

  case 23:
#line 219 "../src/builtin-func.y"
    {
			const char* method_type = 0;
			decl_name = yyvsp[-2].str;

			print_line_directive(fp_func_def);

			if ( definition_type == FUNC_DEF || definition_type == REWRITER_DEF )
				method_type = "function";
			else if ( definition_type == EVENT_DEF )
				method_type = "event";

			if ( method_type )
				fprintf(fp_bro_init,
					"global %s%s: %s%s(",
					bro_prefix, decl_name, method_type, yyvsp[-1].str);

			if ( definition_type == FUNC_DEF || definition_type == REWRITER_DEF )
				{
				fprintf(fp_func_init,
					"\textern Val* %s%s(val_list*);\n",
					c_prefix, decl_name);

				fprintf(fp_func_init,
					"\t(void) new BuiltinFunc(%s%s, \"%s%s\", 0);\n",
					c_prefix, decl_name, bro_prefix, decl_name);

				fprintf(fp_func_h,
					"extern Val* %s%s(val_list*);\n",
					c_prefix, decl_name);

				fprintf(fp_func_def,
					"Val* %s%s(val_list* %s)",
					c_prefix, decl_name, arg_list_name);
				}
			else if ( definition_type == EVENT_DEF )
				{
				fprintf(fp_netvar_h,
					"extern EventHandlerPtr %s;\n",
					decl_name);

				fprintf(fp_netvar_def,
					"EventHandlerPtr %s;\n",
					decl_name);

				fprintf(fp_netvar_init,
					"\t%s = internal_handler(\"%s\");\n",
					decl_name, decl_name);
				}
			}
    break;

  case 24:
#line 271 "../src/builtin-func.y"
    { args.clear(); var_arg = 0; }
    break;

  case 27:
#line 279 "../src/builtin-func.y"
    { /* empty, to avoid yacc complaint about type clash */ }
    break;

  case 29:
#line 284 "../src/builtin-func.y"
    { /* empty */ }
    break;

  case 30:
#line 288 "../src/builtin-func.y"
    { args.push_back(new BuiltinFuncArg(yyvsp[-4].str, yyvsp[0].str)); }
    break;

  case 31:
#line 290 "../src/builtin-func.y"
    {
			if ( definition_type == EVENT_DEF )
				yyerror("events cannot have variable arguments");
			var_arg = 1;
			}
    break;

  case 32:
#line 298 "../src/builtin-func.y"
    {
			BuiltinFuncArg* ret = new BuiltinFuncArg("", yyvsp[-1].str);
			ret->PrintBro(fp_bro_init);
			delete ret;
			fprintf(fp_func_def, "%s", yyvsp[0].str);
			}
    break;

  case 33:
#line 307 "../src/builtin-func.y"
    {
			fprintf(fp_func_def, " // end of %s\n", decl_name);
			print_line_directive(fp_func_def);
			}
    break;

  case 34:
#line 314 "../src/builtin-func.y"
    {
			in_c_code = 1;
			print_line_directive(fp_func_def);
			}
    break;

  case 35:
#line 321 "../src/builtin-func.y"
    { in_c_code = 0; }
    break;

  case 36:
#line 325 "../src/builtin-func.y"
    {
			int implicit_arg = 0;
			int argc = args.size();

			fprintf(fp_func_def, "{");
			if ( definition_type == REWRITER_DEF )
				{
				implicit_arg = 1;
				++argc;
				}

			if ( argc > 0 || ! var_arg )
				fprintf(fp_func_def, "\n");

			if ( ! var_arg )
				{
				fprintf(fp_func_def, "\tif ( %s->length() != %d )\n", arg_list_name, argc);
				fprintf(fp_func_def, "\t\t{\n");
				fprintf(fp_func_def,
					"\t\trun_time(\"%s() takes exactly %d argument(s)\");\n",
					decl_name, argc);
				fprintf(fp_func_def, "\t\treturn 0;\n");
				fprintf(fp_func_def, "\t\t}\n");
				}
			else if ( argc > 0 )
				{
				fprintf(fp_func_def, "\tif ( %s->length() < %d )\n", arg_list_name, argc);
				fprintf(fp_func_def, "\t\t{\n");
				fprintf(fp_func_def,
					"\t\trun_time(\"%s() takes at least %d argument(s)\");\n",
					decl_name, argc);
				fprintf(fp_func_def, "\t\treturn 0;\n");
				fprintf(fp_func_def, "\t\t}\n");
				}

			if ( definition_type == REWRITER_DEF )
				{
				fprintf(fp_func_def,
					"\tTCP_Rewriter* %s = get_trace_rewriter((*%s)[0]);\n",
					trace_rewriter_name,
					arg_list_name);
				fprintf(fp_func_def, "\tif ( ! trace_rewriter )\n");
				fprintf(fp_func_def, "\t\treturn 0;\n");
				}
			for ( int i = 0; i < args.size(); ++i )
				args[i]->PrintCDef(fp_func_def, i + implicit_arg);
			print_line_directive(fp_func_def);
			}
    break;

  case 37:
#line 376 "../src/builtin-func.y"
    {
			if ( definition_type == REWRITER_DEF )
				fprintf(fp_func_def, "\n\treturn 0;\n");
			fprintf(fp_func_def, "}");
			}
    break;

  case 39:
#line 387 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", yyvsp[0].str); }
    break;

  case 40:
#line 389 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", yyvsp[0].str); }
    break;

  case 41:
#line 393 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", yyvsp[0].str); }
    break;

  case 42:
#line 395 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", yyvsp[0].str); }
    break;

  case 43:
#line 397 "../src/builtin-func.y"
    { fprintf(fp_func_def, "(*%s)", arg_list_name); }
    break;

  case 44:
#line 399 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", arg_list_name); }
    break;

  case 45:
#line 401 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s->length()", arg_list_name); }
    break;

  case 46:
#line 403 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", trace_rewriter_name); }
    break;

  case 47:
#line 405 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s->WriteData", trace_rewriter_name); }
    break;

  case 48:
#line 407 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s->Push", trace_rewriter_name); }
    break;

  case 49:
#line 409 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s->EndOfData", trace_rewriter_name); }
    break;

  case 50:
#line 411 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", yyvsp[0].str); }
    break;

  case 51:
#line 413 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%c", yyvsp[0].val); }
    break;

  case 52:
#line 417 "../src/builtin-func.y"
    { yyval.str = concat(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 53:
#line 419 "../src/builtin-func.y"
    { yyval.str = concat(yyvsp[-1].str, "\n"); }
    break;

  case 54:
#line 421 "../src/builtin-func.y"
    {
			if ( in_c_code )
				yyval.str = concat(yyvsp[-1].str, yyvsp[0].str);
			else
				yyval.str = yyvsp[-1].str;
			}
    break;

  case 55:
#line 428 "../src/builtin-func.y"
    { yyval.str = ""; }
    break;


    }

/* Line 1016 of /usr/local/share/bison/yacc.c.  */
#line 1524 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyssp > yyss)
	    {
	      YYDPRINTF ((stderr, "Error: popping "));
	      YYDSYMPRINT ((stderr,
			    yystos[*yyssp],
			    *yyvsp));
	      YYDPRINTF ((stderr, "\n"));
	      yydestruct (yystos[*yyssp], *yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yydestruct (yychar1, yylval);
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDPRINTF ((stderr, "Error: popping "));
      YYDSYMPRINT ((stderr,
		    yystos[*yyssp], *yyvsp));
      YYDPRINTF ((stderr, "\n"));

      yydestruct (yystos[yystate], *yyvsp);
      yyvsp--;
      yystate = *--yyssp;


#if YYDEBUG
      if (yydebug)
	{
	  short *yyssp1 = yyss - 1;
	  YYFPRINTF (stderr, "Error: state stack now");
	  while (yyssp1 != yyssp)
	    YYFPRINTF (stderr, " %d", *++yyssp1);
	  YYFPRINTF (stderr, "\n");
	}
#endif
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 431 "../src/builtin-func.y"


extern char* yytext;
extern char* input_filename;
extern int line_number;
const char* decl_name;

int yyerror(const char msg[])
	{
	char* msgbuf = new char[strlen(msg) + strlen(yytext) + 64];

	if ( yytext[0] == '\n' )
		sprintf(msgbuf, "%s, on previous line", msg);

	else if ( yytext[0] == '\0' )
		sprintf(msgbuf, "%s, at end of file", msg);

	else
		sprintf(msgbuf, "%s, at or near \"%s\"", msg, yytext);

	/*
	extern int column;
	sprintf(msgbuf, "%*s\n%*s\n", column, "^", column, msg);
	*/

	if ( input_filename )
		fprintf(stderr, "%s:%d: ", input_filename, line_number);
	else
		fprintf(stderr, "line %d: ", line_number);
	fprintf(stderr, "%s\n", msgbuf);

	abort();

	exit(1);
	return 0;
	}

