// $Id: input.h,v 1.2 2004/09/08 20:43:23 vern Exp $
//
// Copyright (c) 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003
//      The Regents of the University of California.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that: (1) source code distributions
// retain the above copyright notice and this paragraph in its entirety, (2)
// distributions including binary code include the above copyright notice and
// this paragraph in its entirety in the documentation or other materials
// provided with the distribution, and (3) all advertising materials mentioning
// features or use of this software display the following acknowledgement:
// ``This product includes software developed by the University of California,
// Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
// the University nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
// THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
// WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef input_h
#define input_h

#include "BroList.h"

extern int yyparse();
extern int yydebug;
extern int brolex();
extern char last_tok[128];

extern void add_input_file(const char* file);

// Adds the substrings (using the given delimiter) in a string to the
// given namelist.
extern void add_to_name_list(char* s, char delim, name_list& nl);

extern void begin_RE();
extern void end_RE();

extern void do_atif(Expr* expr);
extern void do_atifdef(const char* id);
extern void do_atifndef(const char* id);
extern void do_atelse();
extern void do_atendif();

extern int line_number;
extern const char* filename;

extern int bro_argc;
extern char** bro_argv;
extern const char* prog;

extern name_list prefixes;	// -p flag
extern char* command_line_policy;	// -e flag

class Stmt;
extern Stmt* stmts;	// global statements

extern int optimize;

extern int nwarn;
extern int nerr;
extern int nruntime;

#endif
