/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TOK_LPP = 258,
     TOK_RPP = 259,
     TOK_LPB = 260,
     TOK_RPB = 261,
     TOK_LPPB = 262,
     TOK_RPPB = 263,
     TOK_VAR_ARG = 264,
     TOK_BOOL = 265,
     TOK_FUNCTION = 266,
     TOK_REWRITER = 267,
     TOK_EVENT = 268,
     TOK_CONST = 269,
     TOK_ENUM = 270,
     TOK_DECLARE = 271,
     TOK_WRITE = 272,
     TOK_PUSH = 273,
     TOK_EOF = 274,
     TOK_TRACE = 275,
     TOK_ARGS = 276,
     TOK_ARG = 277,
     TOK_ARGC = 278,
     TOK_ID = 279,
     TOK_ATTR = 280,
     TOK_CSTR = 281,
     TOK_LF = 282,
     TOK_WS = 283,
     TOK_COMMENT = 284,
     TOK_ATOM = 285,
     TOK_C_TOKEN = 286
   };
#endif
/* Tokens.  */
#define TOK_LPP 258
#define TOK_RPP 259
#define TOK_LPB 260
#define TOK_RPB 261
#define TOK_LPPB 262
#define TOK_RPPB 263
#define TOK_VAR_ARG 264
#define TOK_BOOL 265
#define TOK_FUNCTION 266
#define TOK_REWRITER 267
#define TOK_EVENT 268
#define TOK_CONST 269
#define TOK_ENUM 270
#define TOK_DECLARE 271
#define TOK_WRITE 272
#define TOK_PUSH 273
#define TOK_EOF 274
#define TOK_TRACE 275
#define TOK_ARGS 276
#define TOK_ARG 277
#define TOK_ARGC 278
#define TOK_ID 279
#define TOK_ATTR 280
#define TOK_CSTR 281
#define TOK_LF 282
#define TOK_WS 283
#define TOK_COMMENT 284
#define TOK_ATOM 285
#define TOK_C_TOKEN 286




/* Copy the first part of user declarations.  */
#line 1 "../src/builtin-func.y"

#include <vector>
#include <set>
#include <string>
#include <cstring>

using namespace std;

#include <stdio.h>
#include <stdlib.h>

extern int line_number;
extern char* input_filename;

#define print_line_directive(fp) fprintf(fp, "\n#line %d \"%s\"\n", line_number, input_filename)

extern FILE* fp_bro_init;
extern FILE* fp_func_def;
extern FILE* fp_func_h;
extern FILE* fp_func_init;
extern FILE* fp_netvar_h;
extern FILE* fp_netvar_def;
extern FILE* fp_netvar_init;

int in_c_code = 0;
int definition_type;
const char* bro_prefix;
const char* c_prefix;

enum {
	C_SEGMENT_DEF,
	FUNC_DEF,
	REWRITER_DEF,
	EVENT_DEF,
};

void set_definition_type(int type)
	{
	definition_type = type;
	switch ( type ) {
	case FUNC_DEF:
		bro_prefix = "";
		c_prefix = "bro_";
		break;

	case REWRITER_DEF:
		bro_prefix = "rewrite_";
		c_prefix = "bro_rewrite_";
		break;

	case EVENT_DEF:
		bro_prefix = "";
		c_prefix = "bro_event_";
		break;

	case C_SEGMENT_DEF:
		break;
	}
	}

const char* arg_list_name = "BiF_ARGS";
const char* trace_rewriter_name = "trace_rewriter";

#include "bif_arg.h"

extern const char* decl_name;
int var_arg; // whether the number of arguments is variable
std::vector<BuiltinFuncArg*> args;

// enum types declared by "declare enum <id>"
set<string> enum_types;

extern int yyerror(const char[]);
extern int yywarn(const char msg[]);
extern int yylex();

char* concat(const char* str1, const char* str2)
	{
	int len1 = strlen(str1);
	int len2 = strlen(str2);

	char* s = new char[len1 + len2 +1];

	memcpy(s, str1, len1);
	memcpy(s + len1, str2, len2);

	s[len1+len2] = '\0';

	return s;
	}

// Print the bro_event_* function prototype in C++, without the ending ';'
void print_event_c_prototype(FILE *fp)
	{
	fprintf(fp, "void %s%s(Analyzer* analyzer%s", c_prefix, decl_name,
			args.size() ? ", " : "" );
	for ( int i = 0; i < (int) args.size(); ++i )
		{
		if ( i > 0 )
			fprintf(fp, ", ");
		args[i]->PrintCArg(fp, i);
		}
	fprintf(fp, ")");
	}

// Print the bro_event_* function body in C++.
void print_event_c_body(FILE *fp)
	{
	fprintf(fp, "\t{\n");
	fprintf(fp, "\t// Note that it is intentional that here we do not\n");
	fprintf(fp, "\t// check if %s is NULL, which should happen *before*\n",
		decl_name);
	fprintf(fp, "\t// bro_event_%s is called to avoid unnecessary Val\n",
		decl_name);
	fprintf(fp, "\t// allocation.\n");
	fprintf(fp, "\n");

	fprintf(fp, "\tval_list* vl = new val_list;\n\n");
	BuiltinFuncArg *connection_arg = 0;

	for ( int i = 0; i < (int) args.size(); ++i )
		{
		fprintf(fp, "\t");
		fprintf(fp, "vl->append(");
		args[i]->PrintBroValConstructor(fp);
		fprintf(fp, ");\n");

		if ( args[i]->Type() == TYPE_CONNECTION )
			{
			if ( connection_arg == 0 )
				connection_arg = args[i];
			else
				{
				// We are seeing two connection type arguments.
				yywarn("Warning: with more than connection-type "
				       "event arguments, bifcl only passes "
				       "the first one to EventMgr as cookie.");
				}
			}
		}

	fprintf(fp, "\n");
	fprintf(fp, "\tmgr.QueueEvent(%s, vl, SOURCE_LOCAL, analyzer->GetID(), timer_mgr",
		decl_name);

	if ( connection_arg )
		// Pass the connection to the EventMgr as the "cookie"
		fprintf(fp, ", %s", connection_arg->Name());

	fprintf(fp, ");\n");
	fprintf(fp, "\t} // event generation\n");
	}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
#line 168 "../src/builtin-func.y"
{
	const char* str;
	int val;
}
/* Line 193 of yacc.c.  */
#line 317 "bf.c"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 330 "bf.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   165

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  36
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  38
/* YYNRULES -- Number of rules.  */
#define YYNRULES  66
/* YYNRULES -- Number of states.  */
#define YYNSTATES  129

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   286

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    32,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    33,    34,
       2,    35,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint8 yyprhs[] =
{
       0,     0,     3,     7,     9,    11,    13,    15,    17,    19,
      21,    23,    31,    38,    44,    50,    54,    61,    67,    68,
      73,    78,    79,    81,    86,    91,    92,    93,    99,   101,
     103,   105,   106,   109,   114,   118,   120,   122,   124,   126,
     132,   136,   142,   144,   149,   153,   154,   155,   158,   161,
     167,   169,   173,   175,   177,   179,   181,   183,   185,   187,
     189,   191,   193,   195,   198,   201,   204
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      37,     0,    -1,    37,    38,    73,    -1,    73,    -1,    40,
      -1,    41,    -1,    42,    -1,    70,    -1,    43,    -1,    46,
      -1,    39,    -1,    16,    73,    15,    73,    24,    73,    34,
      -1,    54,    73,    57,    50,    55,    34,    -1,    52,    73,
      56,    55,    65,    -1,    53,    73,    57,    55,    65,    -1,
      44,    45,     6,    -1,    15,    73,    24,    73,     5,    73,
      -1,    45,    24,    73,    32,    73,    -1,    -1,    47,    49,
      50,    34,    -1,    14,    73,    24,    73,    -1,    -1,    49,
      -1,    35,    73,    10,    73,    -1,    35,    73,    26,    73,
      -1,    -1,    -1,    50,    25,    51,    73,    48,    -1,    11,
      -1,    12,    -1,    13,    -1,    -1,    57,    64,    -1,    58,
      61,    60,    73,    -1,    24,    73,    59,    -1,     3,    -1,
       4,    -1,    62,    -1,    73,    -1,    62,    32,    73,    63,
      73,    -1,    73,    63,    73,    -1,    24,    73,    33,    73,
      24,    -1,     9,    -1,    33,    73,    24,    73,    -1,    68,
      71,    69,    -1,    -1,    -1,     5,    66,    -1,     6,    67,
      -1,     7,    66,    71,    67,     8,    -1,    73,    -1,    71,
      72,    73,    -1,    24,    -1,    31,    -1,    22,    -1,    21,
      -1,    23,    -1,    20,    -1,    17,    -1,    18,    -1,    19,
      -1,    26,    -1,    30,    -1,    73,    28,    -1,    73,    27,
      -1,    73,    29,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   175,   175,   177,   198,   199,   200,   201,   202,   203,
     204,   207,   213,   223,   226,   229,   246,   255,   260,   263,
     273,   281,   282,   286,   290,   294,   295,   295,   299,   303,
     307,   312,   317,   322,   346,   402,   406,   409,   410,   414,
     415,   419,   421,   429,   438,   446,   453,   456,   507,   515,
     518,   520,   524,   526,   528,   530,   532,   534,   536,   538,
     540,   542,   544,   548,   550,   552,   560
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "TOK_LPP", "TOK_RPP", "TOK_LPB",
  "TOK_RPB", "TOK_LPPB", "TOK_RPPB", "TOK_VAR_ARG", "TOK_BOOL",
  "TOK_FUNCTION", "TOK_REWRITER", "TOK_EVENT", "TOK_CONST", "TOK_ENUM",
  "TOK_DECLARE", "TOK_WRITE", "TOK_PUSH", "TOK_EOF", "TOK_TRACE",
  "TOK_ARGS", "TOK_ARG", "TOK_ARGC", "TOK_ID", "TOK_ATTR", "TOK_CSTR",
  "TOK_LF", "TOK_WS", "TOK_COMMENT", "TOK_ATOM", "TOK_C_TOKEN", "','",
  "':'", "';'", "'='", "$accept", "definitions", "definition",
  "declare_def", "event_def", "func_def", "rewriter_def", "enum_def",
  "enum_def_1", "enum_list", "const_def", "const_def_1", "opt_const_init",
  "const_init", "opt_attr", "@1", "func_prefix", "rewriter_prefix",
  "event_prefix", "end_of_head", "typed_head", "plain_head", "head_1",
  "arg_begin", "arg_end", "args", "args_1", "arg", "return_type", "body",
  "c_code_begin", "c_code_end", "body_start", "body_end", "c_code_segment",
  "c_body", "c_atom", "opt_ws", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,    44,    58,    59,    61
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    36,    37,    37,    38,    38,    38,    38,    38,    38,
      38,    39,    40,    41,    42,    43,    44,    45,    45,    46,
      47,    48,    48,    49,    49,    50,    51,    50,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    61,    62,
      62,    63,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    71,    72,    72,    72,    72,    72,    72,    72,    72,
      72,    72,    72,    73,    73,    73,    73
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     7,     6,     5,     5,     3,     6,     5,     0,     4,
       4,     0,     1,     4,     4,     0,     0,     5,     1,     1,
       1,     0,     2,     4,     3,     1,     1,     1,     1,     5,
       3,     5,     1,     4,     3,     0,     0,     2,     2,     5,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
      66,     0,     3,     1,    45,    28,    29,    30,    66,    66,
      66,    66,    10,     4,     5,     6,     8,    18,     9,     0,
      66,    66,    66,     7,    64,    63,    65,    66,     0,     0,
       0,     2,     0,    66,    25,     0,     0,     0,    46,    50,
      66,    66,    66,    15,    66,     0,     0,    66,    31,     0,
      66,    31,    25,    58,    59,    60,    57,    55,    54,    56,
      52,    61,    62,    53,     0,    66,    20,     0,     0,     0,
      66,    66,    26,    19,     0,     0,    66,    32,     0,    37,
      38,     0,    31,    49,    51,    66,    66,    66,    23,    24,
      66,    35,    34,    45,    13,    66,     0,    36,    66,    66,
      42,    66,    66,    14,     0,    16,     0,    17,    21,    47,
       0,    66,    33,     0,     0,    40,    12,    11,    27,    22,
      46,    44,    43,    66,    66,    48,    39,     0,    41
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     1,    11,    12,    13,    14,    15,    16,    17,    32,
      18,    19,   118,    34,    46,    90,    20,    21,    22,    75,
      48,    49,    50,    92,    98,    78,    79,   102,    77,    94,
      27,    64,    95,   121,    23,    38,    65,    39
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -51
static const yytype_int16 yypact[] =
{
     -51,    93,   -23,   -51,   -51,   -51,   -51,   -51,   -51,   -51,
     -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -19,
     -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,    24,    45,
      67,   -23,    11,   -51,   -51,   118,   118,   118,    95,   -23,
     -51,   -51,   -51,   -51,   -51,    52,   -22,   -51,   -51,    -8,
     -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,
     -51,   -51,   -51,   -51,    28,   -51,   -23,     2,   124,   -14,
     -51,   -51,   -51,   -51,    -1,    40,   -51,   -51,    42,    17,
      10,    40,    39,   -51,   -23,   -51,   -51,   -51,   -23,   -23,
     -51,   -51,   -51,   -51,   -51,   -51,   130,   -51,   -51,   -51,
     -51,   -51,   -51,   -51,    32,   -23,   103,   -23,   100,   -51,
      37,   -51,   -23,    10,   111,   -23,   -51,   -51,   -51,   -51,
     -51,   -51,   -23,   -51,   -51,   -51,   -23,   136,   -51
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,   -51,
     -51,   -51,   -51,   -33,    25,   -51,   -51,   -51,   -51,   -50,
     -51,   -13,   -51,   -51,   -51,   -51,   -51,   -30,   -51,     3,
      -5,   -31,   -51,   -51,   -51,    -4,   -51,     0
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint8 yytable[] =
{
       2,    81,    91,    72,    24,    25,    26,    85,    28,    29,
      30,    31,    73,    24,    25,    26,    33,    43,    87,   100,
      35,    36,    37,    51,    52,    76,    24,    25,    26,    24,
      25,    26,   104,    45,   101,    44,    83,    24,    25,    26,
      66,    67,    68,   120,    69,    93,    97,    74,    40,    99,
      80,    24,    25,    26,    53,    54,    55,    56,    57,    58,
      59,    60,    70,    61,    72,    84,   116,    62,    63,    41,
      88,    89,    24,    25,    26,   119,    96,    82,    71,    24,
      25,    26,    42,   123,   103,   105,   106,   107,   109,   125,
     108,   110,     0,     3,    24,    25,    26,     0,   112,   113,
       4,   114,   115,     0,     5,     6,     7,     8,     9,    10,
       0,   122,    53,    54,    55,    56,    57,    58,    59,    60,
       0,    61,     0,   126,   127,    62,    63,    24,    25,    26,
      24,    25,    26,     0,     0,    33,     0,   117,    24,    25,
      26,     0,    47,     0,   124,    24,    25,    26,    86,     0,
       0,    24,    25,    26,   111,     0,     0,    24,    25,    26,
     128,     0,     0,    24,    25,    26
};

static const yytype_int8 yycheck[] =
{
       0,    51,     3,    25,    27,    28,    29,     5,     8,     9,
      10,    11,    34,    27,    28,    29,    35,     6,    32,     9,
      20,    21,    22,    36,    37,    33,    27,    28,    29,    27,
      28,    29,    82,    33,    24,    24,     8,    27,    28,    29,
      40,    41,    42,     6,    44,     5,     4,    47,    24,    32,
      50,    27,    28,    29,    17,    18,    19,    20,    21,    22,
      23,    24,    10,    26,    25,    65,    34,    30,    31,    24,
      70,    71,    27,    28,    29,   108,    76,    52,    26,    27,
      28,    29,    15,   113,    81,    85,    86,    87,    93,   120,
      90,    95,    -1,     0,    27,    28,    29,    -1,    98,    99,
       7,   101,   102,    -1,    11,    12,    13,    14,    15,    16,
      -1,   111,    17,    18,    19,    20,    21,    22,    23,    24,
      -1,    26,    -1,   123,   124,    30,    31,    27,    28,    29,
      27,    28,    29,    -1,    -1,    35,    -1,    34,    27,    28,
      29,    -1,    24,    -1,    33,    27,    28,    29,    24,    -1,
      -1,    27,    28,    29,    24,    -1,    -1,    27,    28,    29,
      24,    -1,    -1,    27,    28,    29
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    37,    73,     0,     7,    11,    12,    13,    14,    15,
      16,    38,    39,    40,    41,    42,    43,    44,    46,    47,
      52,    53,    54,    70,    27,    28,    29,    66,    73,    73,
      73,    73,    45,    35,    49,    73,    73,    73,    71,    73,
      24,    24,    15,     6,    24,    73,    50,    24,    56,    57,
      58,    57,    57,    17,    18,    19,    20,    21,    22,    23,
      24,    26,    30,    31,    67,    72,    73,    73,    73,    73,
      10,    26,    25,    34,    73,    55,    33,    64,    61,    62,
      73,    55,    50,     8,    73,     5,    24,    32,    73,    73,
      51,     3,    59,     5,    65,    68,    73,     4,    60,    32,
       9,    24,    63,    65,    55,    73,    73,    73,    73,    66,
      71,    24,    73,    73,    73,    73,    34,    34,    48,    49,
       6,    69,    73,    63,    33,    67,    73,    73,    24
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 176 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", (yyvsp[(3) - (3)].str)); }
    break;

  case 3:
#line 178 "../src/builtin-func.y"
    {
			int n = 1024 + strlen(input_filename);
			char auto_gen_comment[n];

			snprintf(auto_gen_comment, n,
				"This file was automatically generated by bifcl from %s.",
				input_filename);

			fprintf(fp_bro_init, "# %s\n\n", auto_gen_comment);
			fprintf(fp_func_def, "// %s\n\n", auto_gen_comment);
			fprintf(fp_func_h, "// %s\n\n", auto_gen_comment);
			fprintf(fp_func_init, "// %s\n\n", auto_gen_comment);
			fprintf(fp_netvar_def, "// %s\n\n", auto_gen_comment);
			fprintf(fp_netvar_h, "// %s\n\n", auto_gen_comment);
			fprintf(fp_netvar_init, "// %s\n\n", auto_gen_comment);

			fprintf(fp_func_def, "%s", (yyvsp[(1) - (1)].str));
			}
    break;

  case 11:
#line 208 "../src/builtin-func.y"
    {
			enum_types.insert((yyvsp[(5) - (7)].str));
			}
    break;

  case 12:
#line 214 "../src/builtin-func.y"
    {
			print_event_c_prototype(fp_func_h);
			fprintf(fp_func_h, ";\n");
			print_event_c_prototype(fp_func_def);
			fprintf(fp_func_def, "\n");
			print_event_c_body(fp_func_def);
			}
    break;

  case 15:
#line 230 "../src/builtin-func.y"
    {
			// First, put an end to the enum type decl.
			fprintf(fp_bro_init, "};\n");
			fprintf(fp_netvar_h, "}; }\n");

			// Now generate the netvar's.
			fprintf(fp_netvar_h,
				"extern EnumType* enum_%s;\n", decl_name);
			fprintf(fp_netvar_def,
				"EnumType* enum_%s;\n", decl_name);
			fprintf(fp_netvar_init,
				"\tenum_%s = internal_type(\"%s\")->AsEnumType();\n",
				decl_name, decl_name);
			}
    break;

  case 16:
#line 247 "../src/builtin-func.y"
    {
			decl_name = (yyvsp[(3) - (6)].str);
			fprintf(fp_bro_init, "type %s: enum %s{%s", (yyvsp[(3) - (6)].str), (yyvsp[(4) - (6)].str), (yyvsp[(6) - (6)].str));
			fprintf(fp_netvar_h, "namespace BroEnum { ");
			fprintf(fp_netvar_h, "enum %s {\n", (yyvsp[(3) - (6)].str));
			}
    break;

  case 17:
#line 256 "../src/builtin-func.y"
    {
			fprintf(fp_bro_init, "%s%s,%s", (yyvsp[(2) - (5)].str), (yyvsp[(3) - (5)].str), (yyvsp[(5) - (5)].str));
			fprintf(fp_netvar_h, "\t%s,\n", (yyvsp[(2) - (5)].str));
			}
    break;

  case 19:
#line 264 "../src/builtin-func.y"
    {
			fprintf(fp_bro_init, ";\n");
			fprintf(fp_netvar_h, "extern int %s;\n", decl_name);
			fprintf(fp_netvar_def, "int %s;\n", decl_name);
			fprintf(fp_netvar_init, "\t%s = internal_val(\"%s\")->AsBool();\n",
				decl_name, decl_name);
			}
    break;

  case 20:
#line 274 "../src/builtin-func.y"
    {
			decl_name = (yyvsp[(3) - (4)].str);
			fprintf(fp_bro_init, "const%s", (yyvsp[(2) - (4)].str));
			fprintf(fp_bro_init, "%s: bool%s", (yyvsp[(3) - (4)].str), (yyvsp[(4) - (4)].str));
			}
    break;

  case 23:
#line 287 "../src/builtin-func.y"
    {
			fprintf(fp_bro_init, "=%s%c%s", (yyvsp[(2) - (4)].str), ((yyvsp[(3) - (4)].val)) ? 'T' : 'F', (yyvsp[(4) - (4)].str));
			}
    break;

  case 24:
#line 291 "../src/builtin-func.y"
    { fprintf(fp_bro_init, "=%s%s%s", (yyvsp[(2) - (4)].str), (yyvsp[(3) - (4)].str), (yyvsp[(4) - (4)].str)); }
    break;

  case 26:
#line 295 "../src/builtin-func.y"
    { fprintf(fp_bro_init, "%s", (yyvsp[(2) - (2)].str)); }
    break;

  case 28:
#line 300 "../src/builtin-func.y"
    { set_definition_type(FUNC_DEF); }
    break;

  case 29:
#line 304 "../src/builtin-func.y"
    { set_definition_type(REWRITER_DEF); }
    break;

  case 30:
#line 308 "../src/builtin-func.y"
    { set_definition_type(EVENT_DEF); }
    break;

  case 31:
#line 312 "../src/builtin-func.y"
    {
			fprintf(fp_bro_init, ";\n");
			}
    break;

  case 32:
#line 318 "../src/builtin-func.y"
    {
			}
    break;

  case 33:
#line 323 "../src/builtin-func.y"
    {
			if ( var_arg )
				fprintf(fp_bro_init, "va_args: any");
			else
				{
				if ( definition_type == REWRITER_DEF )
					fprintf(fp_bro_init, "c: connection");

				for ( int i = 0; i < (int) args.size(); ++i )
					{
					if ( i > 0 || definition_type == REWRITER_DEF )
						fprintf(fp_bro_init, ", ");
					args[i]->PrintBro(fp_bro_init);
					}
				}

			fprintf(fp_bro_init, ")");

			fprintf(fp_bro_init, "%s", (yyvsp[(4) - (4)].str));
			fprintf(fp_func_def, "%s", (yyvsp[(4) - (4)].str));
			}
    break;

  case 34:
#line 347 "../src/builtin-func.y"
    {
			const char* method_type = 0;
			decl_name = (yyvsp[(1) - (3)].str);

			if ( definition_type == FUNC_DEF || definition_type == REWRITER_DEF )
				{
				method_type = "function";
				print_line_directive(fp_func_def);
				}
			else if ( definition_type == EVENT_DEF )
				method_type = "event";

			if ( method_type )
				fprintf(fp_bro_init,
					"global %s%s: %s%s(",
					bro_prefix, decl_name, method_type, (yyvsp[(2) - (3)].str));

			if ( definition_type == FUNC_DEF || definition_type == REWRITER_DEF )
				{
				fprintf(fp_func_init,
					"\textern Val* %s%s(Frame* frame, val_list*);\n",
					c_prefix, decl_name);

				fprintf(fp_func_init,
					"\t(void) new BuiltinFunc(%s%s, \"%s%s\", 0);\n",
					c_prefix, decl_name, bro_prefix, decl_name);

				fprintf(fp_func_h,
					"extern Val* %s%s(Frame* frame, val_list*);\n",
					c_prefix, decl_name);

				fprintf(fp_func_def,
					"Val* %s%s(Frame* frame, val_list* %s)",
					c_prefix, decl_name, arg_list_name);
				}
			else if ( definition_type == EVENT_DEF )
				{
				fprintf(fp_netvar_h,
					"extern EventHandlerPtr %s;\n",
					decl_name);

				fprintf(fp_netvar_def,
					"EventHandlerPtr %s;\n",
					decl_name);

				fprintf(fp_netvar_init,
					"\t%s = internal_handler(\"%s\");\n",
					decl_name, decl_name);

				// C++ prototypes of bro_event_* functions will
				// be generated later.
				}
			}
    break;

  case 35:
#line 403 "../src/builtin-func.y"
    { args.clear(); var_arg = 0; }
    break;

  case 38:
#line 411 "../src/builtin-func.y"
    { /* empty, to avoid yacc complaint about type clash */ }
    break;

  case 40:
#line 416 "../src/builtin-func.y"
    { /* empty */ }
    break;

  case 41:
#line 420 "../src/builtin-func.y"
    { args.push_back(new BuiltinFuncArg((yyvsp[(1) - (5)].str), (yyvsp[(5) - (5)].str))); }
    break;

  case 42:
#line 422 "../src/builtin-func.y"
    {
			if ( definition_type == EVENT_DEF )
				yyerror("events cannot have variable arguments");
			var_arg = 1;
			}
    break;

  case 43:
#line 430 "../src/builtin-func.y"
    {
			BuiltinFuncArg* ret = new BuiltinFuncArg("", (yyvsp[(3) - (4)].str));
			ret->PrintBro(fp_bro_init);
			delete ret;
			fprintf(fp_func_def, "%s", (yyvsp[(4) - (4)].str));
			}
    break;

  case 44:
#line 439 "../src/builtin-func.y"
    {
			fprintf(fp_func_def, " // end of %s\n", decl_name);
			print_line_directive(fp_func_def);
			}
    break;

  case 45:
#line 446 "../src/builtin-func.y"
    {
			in_c_code = 1;
			print_line_directive(fp_func_def);
			}
    break;

  case 46:
#line 453 "../src/builtin-func.y"
    { in_c_code = 0; }
    break;

  case 47:
#line 457 "../src/builtin-func.y"
    {
			int implicit_arg = 0;
			int argc = args.size();

			fprintf(fp_func_def, "{");
			if ( definition_type == REWRITER_DEF )
				{
				implicit_arg = 1;
				++argc;
				}

			if ( argc > 0 || ! var_arg )
				fprintf(fp_func_def, "\n");

			if ( ! var_arg )
				{
				fprintf(fp_func_def, "\tif ( %s->length() != %d )\n", arg_list_name, argc);
				fprintf(fp_func_def, "\t\t{\n");
				fprintf(fp_func_def,
					"\t\trun_time(\"%s() takes exactly %d argument(s)\");\n",
					decl_name, argc);
				fprintf(fp_func_def, "\t\treturn 0;\n");
				fprintf(fp_func_def, "\t\t}\n");
				}
			else if ( argc > 0 )
				{
				fprintf(fp_func_def, "\tif ( %s->length() < %d )\n", arg_list_name, argc);
				fprintf(fp_func_def, "\t\t{\n");
				fprintf(fp_func_def,
					"\t\trun_time(\"%s() takes at least %d argument(s)\");\n",
					decl_name, argc);
				fprintf(fp_func_def, "\t\treturn 0;\n");
				fprintf(fp_func_def, "\t\t}\n");
				}

			if ( definition_type == REWRITER_DEF )
				{
				fprintf(fp_func_def,
					"\tRewriter* %s = get_trace_rewriter((*%s)[0]);\n",
					trace_rewriter_name,
					arg_list_name);
				fprintf(fp_func_def, "\tif ( ! trace_rewriter )\n");
				fprintf(fp_func_def, "\t\treturn 0;\n");
				}
			for ( int i = 0; i < (int) args.size(); ++i )
				args[i]->PrintCDef(fp_func_def, i + implicit_arg);
			print_line_directive(fp_func_def);
			}
    break;

  case 48:
#line 508 "../src/builtin-func.y"
    {
			if ( definition_type == REWRITER_DEF )
				fprintf(fp_func_def, "\n\treturn 0;\n");
			fprintf(fp_func_def, "}");
			}
    break;

  case 50:
#line 519 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", (yyvsp[(1) - (1)].str)); }
    break;

  case 51:
#line 521 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", (yyvsp[(3) - (3)].str)); }
    break;

  case 52:
#line 525 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", (yyvsp[(1) - (1)].str)); }
    break;

  case 53:
#line 527 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", (yyvsp[(1) - (1)].str)); }
    break;

  case 54:
#line 529 "../src/builtin-func.y"
    { fprintf(fp_func_def, "(*%s)", arg_list_name); }
    break;

  case 55:
#line 531 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", arg_list_name); }
    break;

  case 56:
#line 533 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s->length()", arg_list_name); }
    break;

  case 57:
#line 535 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", trace_rewriter_name); }
    break;

  case 58:
#line 537 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s->WriteData", trace_rewriter_name); }
    break;

  case 59:
#line 539 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s->Push", trace_rewriter_name); }
    break;

  case 60:
#line 541 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s->EndOfData", trace_rewriter_name); }
    break;

  case 61:
#line 543 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%s", (yyvsp[(1) - (1)].str)); }
    break;

  case 62:
#line 545 "../src/builtin-func.y"
    { fprintf(fp_func_def, "%c", (yyvsp[(1) - (1)].val)); }
    break;

  case 63:
#line 549 "../src/builtin-func.y"
    { (yyval.str) = concat((yyvsp[(1) - (2)].str), (yyvsp[(2) - (2)].str)); }
    break;

  case 64:
#line 551 "../src/builtin-func.y"
    { (yyval.str) = concat((yyvsp[(1) - (2)].str), "\n"); }
    break;

  case 65:
#line 553 "../src/builtin-func.y"
    {
			if ( in_c_code )
				(yyval.str) = concat((yyvsp[(1) - (2)].str), (yyvsp[(2) - (2)].str));
			else
				(yyval.str) = (yyvsp[(1) - (2)].str);
			}
    break;

  case 66:
#line 560 "../src/builtin-func.y"
    { (yyval.str) = ""; }
    break;


/* Line 1267 of yacc.c.  */
#line 2084 "bf.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 563 "../src/builtin-func.y"


extern char* yytext;
extern char* input_filename;
extern int line_number;
const char* decl_name;

void print_msg(const char msg[])
	{
	int msg_len = strlen(msg) + strlen(yytext) + 64;
	char* msgbuf = new char[msg_len];

	if ( yytext[0] == '\n' )
		snprintf(msgbuf, msg_len, "%s, on previous line", msg);

	else if ( yytext[0] == '\0' )
		snprintf(msgbuf, msg_len, "%s, at end of file", msg);

	else
		snprintf(msgbuf, msg_len, "%s, at or near \"%s\"", msg, yytext);

	/*
	extern int column;
	sprintf(msgbuf, "%*s\n%*s\n", column, "^", column, msg);
	*/

	if ( input_filename )
		fprintf(stderr, "%s:%d: ", input_filename, line_number);
	else
		fprintf(stderr, "line %d: ", line_number);
	fprintf(stderr, "%s\n", msgbuf);

	delete [] msgbuf;
	}

int yywarn(const char msg[])
	{
	print_msg(msg);
	return 0;
	}

int yyerror(const char msg[])
	{
	print_msg(msg);

	abort();
	exit(1);
	return 0;
	}

